<?php

/*
 * Plugin Name:      SEO for wpDataTables Master-Detail
 * Plugin URI:       https://antero.eu/seo-for-wdt-md/
 * Description:      This plugin addresses several SEO considerations of wpDataTables Master-Detail pages, while also providing them clean URLs.
 * Version:          2.1.0
 * Author:           Antero Alex Kiltti
 * Author URI:       https://antero.eu
 * License:          GPL v2 or later
 * License URI:      https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI:       https://antero.eu/seo-for-wdt-md/
 * Text Domain:      seo-for-wdt-md
 * Requires Plugins: wpdatatables, wdt-master-detail
 */

if ( !defined('ABSPATH') ) exit;

require_once(plugin_dir_path(__FILE__).'functions.php');

sfwm_settings();

register_activation_hook(__FILE__, 'sfwm_activate');
register_deactivation_hook(__FILE__, 'sfwm_deactivate');
add_action('admin_notices', 'sfwm_admin_notices');

if ( SFWM_CFG["Configured"] )
{
    add_filter('query_vars', 'sfwm_query_vars');
    add_filter('wp_headers', 'sfwm_headers');
    add_filter('pre_get_document_title', 'sfwm_set_title');
    add_filter('get_canonical_url', 'sfwm_set_canonical', 10, 2);
    add_action('init', 'sfwm_rewrite_rules');
    add_action('parse_query', 'sfwm_pass_request');
    add_action('template_redirect', 'sfwm_request_handler', 9);
    add_action('wp_head', 'sfwm_head', 1);
}